﻿
*Licencia Creative Commons Attribution-NonCommercial 4.0.
*Código de registro: 1907061367396.
*Fecha de registro: 06-jul-2019 16:47 UTC.
*Josep Pascual i Bardají www.pascalpsi.es.
*GNU PSPP.
*Leemos los datos del fichero fdefac06. El fichero txt ha de ser proporcionado por el Instituto Nacional de Estadística.
*GNU PSPP.
*Leemos los datos del fichero fichero_anonimizado_defunciones_2012_estudios. El fichero txt ha de ser proporcionado por el Instituto Nacional de Estadística.
DATA LIST FILE='/home/lluc1/Documents/Estudis/Epidemiologia/Esperanza/2012-2013/fichero_anonimizado_defunciones_2012_estudios.txt'
/
CPROI 1-2
CMUNI 3-5
MESN 6-7
ANON 8-11
SEXO 12
MESDEF 13-14    
ANODEF 15-18
NACIONALIDAD 19
PAISNAC 20-22
LUGNAC 23
CPRON 24-25
CMUNN 26-28
PAISNX 29-31
LUGRES 32
CPRORE 33-34
CMUNRE 35-37
PAISREX 38-40
ECIV 41
CODPROF 42-43
ANOSC 44-46
MESESC 47-48
DIASC 49-50
TAMAMUNI 51
TAMAMUNINAC 52
TAMAMUNIRES 53
TAMAPAISNACIMI 54
TAMAPAISRESIDE 55
TAMAPAISNACIONA 56
CBAS1 57 (A)
CBAS23 58-59 (A)
CBAS4 60 (A)
CAUSAR 61-63
CAUSAP 64-65
CAUSAINF 66-67
NESTUDIOS 68-69
LUGARDEF 70-70
BLANCO 71-87.

VARIABLE LABELS 
CPROI 'Código Provincia de Inscripción'
CMUNI 'CODIGO DE MUNICIPIO DE INSCRIPCION (PARA MUN. >10.000 HABIT.)'
MESN 'MES DE NACIMIENTO'
ANON 'AÑO DE NACIMIENTO'
SEXO 'SEXO'
MESDEF 'MES DE DEFUNCION'
ANODEF 'AÑO DE DEFUNCION'
NACIONALIDAD 'Nacionalidad'
PAISNAC 'Código país nacionalidad del fallecido'
LUGNAC 'Lugar de nacimiento del fallecido'
CPRON 'Código provincia nacimiento  del fallecido'
CMUNN 'Código municipio nacimiento  del fallecido (para municipios mayores de 10.000 habitantes)'
PAISNX 'Código país de nacimiento extranjero del fallecido'
LUGRES 'Lugar de residencia del fallecido'
CPRORE 'Código provincia de residencia del fallecido'
CMUNRE 'Código municipio residencia del fallecido (para municipios mayores de 10.000 habitantes)'
PAISREX 'Código de país de residencia extranjero del fallecido'
ECIV 'Estado civil del fallecido'
CODPROF 'Código autoasignado de la profesión, oficio u ocupación principal del fallecido'
ANOSC 'Años cumpñidos'
MESESC 'Meses cumplidos (para menores de un año)'
DIASC 'Dias cumplidos (para menores de un mes)'
TAMAMUNI 'Tamaño municipio de inscripción'
TAMAMUNINAC 'Tamaño municipio nacimiento'
TAMAMUNIRES 'Tamaño municipio residencia'
TAMAPAISNACIMI 'Tamaño pais nacimiento'
TAMAPAISRESIDE 'Tamaño pais residencia'
TAMAPAISNACIONA 'Tamaño pais nacionalidad'
CBAS1 '1er carácter del código de causa básica'
CBAS23 '2º y 3er carácter del código de causa básica'
CBAS4 '2º y 4º carácter del código de causa básica'
CAUSAR 'causa de mortalidad reducida (102 grupos)'
CAUSAP 'Causa de mortalidad perinatal ( 93 grupos)'
CAUSAINF 'Causa de mortalidad infantil (54 grupos) para menores de 1 año'
NESTUDIOS 'Nivel de estudios'
LUGARDEF 'Lugar de defunción'
BLANCO 'Campo a blancos'.
EXECUTE.

VALUE LABELS 
/CPROI, CPRON, CPRORE
1 'ALAVA'
2 'ALBACETE'
3 'ALICANTE/ALACANT'
4 'ALMERIA'
5 'AVILA'
6 'BADAJOZ'
7 'BALEARS ILLES'
8 'BARCELONA'
9 'BURGOS'
10 'CACERES'
11 'CADIZ'
12 'CASTELLON/CASTELLO'
13 'CIUDAD REAL'
14 'CORDOBA'
15 'CORUÑA A'
16 'CUENCA'
17 'GIRONA'
18 'GRANADA'
19 'GUADALAJARA'
20 'GUIPUZCOA'
21 'HUELVA'
22 'HUESCA'
23 'JAEN'
24 'LEON'
25 'LLEIDA'
26 'RIOJA LA'
27 'LUGO'
28 'MADRID'
29 'MALAGA'
30 'MURCIA'
31 'NAVARRA'
32 'OURENSE'
33 'ASTURIAS'
34 'PALENCIA'
35 'PALMAS LAS'
36 'PONTEVEDRA'
37 'SALAMANCA'
38 'SANTA CRUZ DE TENERIFE'
39 'CANTABRIA'
40 'SEGOVIA'
41 'SEVILLA '
42 'SORIA'
43 'TARRAGONA'
44 'TERUEL'
45 'TOLEDO'
46 'VALENCIA'
47 'VALLADOLID'
48 'VIZCAYA'
49 'ZAMORA'
50 'ZARAGOZA'
51 'CEUTA'
52 'MELILLA'
66 'EXTRANJERO'
/MESN, MESDEF
'01' 'Enero' '02' 'Febrero' '03' 'Marzo' '04' 'Abril' '05' 'Mayo' '06' 'Junio' '07' 'Julio' '08' 'Agosto' '09' 'Septiembre' '10' 'Octubre' '11' 'Noviembre' '12' 'Diciembre'
/SEXO
1 'Varón'
6 'Mujer'
/NACIONALIDAD, LUGNAC
0 'No consta'
1 'Española'
2 'Extranjera'
/PAISNAC, PAISNX, PAISREX
102 'AUSTRIA'
103 'BELGICA'
104 'BULGARIA'
106 'CHIPRE'
107 'DINAMARCA'
108 'ESPAÑA'
109 'FINLANDIA'
110 'FRANCIA'
111 'GRECIA'
112 'HUNGRIA'
113 'IRLANDA'
115 'ITALIA'
117 'LUXEMBURGO'
118 'MALTA'
121 'PAISES BAJOS'
122 'POLONIA'
123 'PORTUGAL'
125 'REINO UNIDO'
126 'ALEMANIA'
128 'RUMANIA'
131 'SUECIA'
136 'LETONIA'
141 'ESTONIA'
142 'LITUANIA'
143 'REPUBLICA CHECA'
144 'REPUBLICA ESLOVACA'
147 'ESLOVENIA'
198 'OTROS PAISES O TERRITORIOS DE LA UNION EUROPEA'
101 'ALBANIA'
114 'ISLANDIA'
116 'LIECHTENSTEIN'
119 'MONACO'
120 'NORUEGA'
124 'ANDORRA'
129 'SAN MARINO'
130 'SANTA SEDE'
132 'SUIZA'
135 'UCRANIA'
137 'MOLDAVIA'
138 'BELARUS'
139 'GEORGIA'
145 'BOSNIA Y HERZEGOVINA'
146 'CROACIA'
148 'ARMENIA'
154 'RUSIA'
156 'MACEDONIA '
157 'SERBIA'
158 'MONTENEGRO'
170 'GUERNESEY'
171 'SVALBARD Y JAN MAYEN'
172 'ISLAS FEROE'
173 'ISLA DE MAN'
174 'GIBRALTAR'
175 'ISLAS DEL CANAL'
176 'JERSEY'
177 'ISLAS ALAND'
436 'TURQUIA'
199 'OTROS PAISES O TERRITORIOS DEL RESTO DE EUROPA'
201 'BURKINA FASO'
202 'ANGOLA'
203 'ARGELIA'
204 'BENIN'
205 'BOTSWANA'
206 'BURUNDI'
207 'CABO VERDE'
208 'CAMERUN'
209 'COMORES'
210 'CONGO'
211 'COSTA DE MARFIL'
212 'DJIBOUTI'
213 'EGIPTO'
214 'ETIOPIA'
215 'GABON'
216 'GAMBIA'
217 'GHANA'
218 'GUINEA'
219 'GUINEA-BISSAU'
220 'GUINEA ECUATORIAL'
221 'KENIA'
222 'LESOTHO'
223 'LIBERIA'
224 'LIBIA'
225 'MADAGASCAR'
226 'MALAWI'
227 'MALI'
228 'MARRUECOS'
229 'MAURICIO'
230 'MAURITANIA'
231 'MOZAMBIQUE'
232 'NAMIBIA'
233 'NIGER'
234 'NIGERIA'
235 'REPUBLICA CENTROAFRICANA'
236 'SUDAFRICA'
237 'RUANDA'
238 'SANTO TOME Y PRINCIPE'
239 'SENEGAL'
240 'SEYCHELLES'
241 'SIERRA LEONA'
242 'SOMALIA'
243 'SUDAN'
244 'SWAZILANDIA'
245 'TANZANIA'
246 'CHAD'
247 'TOGO'
248 'TUNEZ'
249 'UGANDA'
250 'REP.DEMOCRATICA DEL CONGO'
251 'ZAMBIA'
252 'ZIMBABWE'
253 'ERITREA'
260 'SANTA HELENA'
261 'REUNION'
262 'MAYOTTE'
263 'SAHARA OCCIDENTAL'
299 'OTROS PAISES O TERRITORIOS DE AFRICA'
301 'CANADA'
302 'ESTADOS UNIDOS DE AMERICA'
303 'MEXICO'
370 'SAN PEDRO Y MIQUELON '
371 'GROENLANDIA'
396 'OTROS PAISES  O TERRITORIOS DE AMERICA DEL NORTE'
310 'ANTIGUA Y BARBUDA'
311 'BAHAMAS'
312 'BARBADOS'
313 'BELICE'
314 'COSTA RICA'
315 'CUBA'
316 'DOMINICA'
317 'EL SALVADOR'
318 'GRANADA'
319 'GUATEMALA'
320 'HAITI'
321 'HONDURAS'
322 'JAMAICA'
323 'NICARAGUA'
324 'PANAMA'
325 'SAN VICENTE Y LAS GRANADINAS'
326 'REPUBLICA DOMINICANA'
327 'TRINIDAD Y TOBAGO'
328 'SANTA LUCIA'
329 'SAN CRISTOBAL Y NIEVES'
380 'ISLAS CAIMÁN'
381 'ISLAS TURCAS Y CAICOS'
382 'ISLAS VÍRGENES DE LOS ESTADOS UNIDOS'
383 'GUADALUPE'
384 'ANTILLAS HOLANDESAS'
385 'SAN MARTIN (PARTE FRANCESA)'
386 'ARUBA'
387 'MONTSERRAT'
388 'ANGUILLA'
389 'SAN BARTOLOME'
390 'MARTINICA'
391 'PUERTO RICO'
392 'BERMUDAS'
393 'ISLAS VIRGENES BRITANICAS'
398 'OTROS PAISES O TERRITORIOS DEL CARIBE Y AMERICA CENTRAL'
340 'ARGENTINA'
341 'BOLIVIA'
342 'BRASIL'
343 'COLOMBIA'
344 'CHILE'
345 'ECUADOR'
346 'GUYANA'
347 'PARAGUAY'
348 'PERU'
349 'SURINAM'
350 'URUGUAY'
351 'VENEZUELA'
394 'GUAYANA FRANCESA'
395 'ISLAS MALVINAS'
399 'OTROS PAISES O TERRITORIOS  DE SUDAMERICA'
401 'AFGANISTAN'
402 'ARABIA SAUDI'
403 'BAHREIN'
404 'BANGLADESH'
405 'MYANMAR'
407 'CHINA'
408 'EMIRATOS ARABES UNIDOS'
409 'FILIPINAS'
410 'INDIA'
411 'INDONESIA'
412 'IRAQ'
413 'IRAN'
414 'ISRAEL'
415 'JAPON'
416 'JORDANIA'
417 'CAMBOYA'
418 'KUWAIT'
419 'LAOS'
420 'LIBANO'
421 'MALASIA'
422 'MALDIVAS'
423 'MONGOLIA'
424 'NEPAL'
425 'OMAN'
426 'PAKISTAN'
427 'QATAR'
430 'COREA'
431 'COREA DEL NORTE '
432 'SINGAPUR'
433 'SIRIA'
434 'SRI LANKA'
435 'TAILANDIA'
437 'VIETNAM'
439 'BRUNEI'
440 'ISLAS MARSHALL'
441 'YEMEN'
442 'AZERBAIYAN'
443 'KAZAJSTAN'
444 'KIRGUISTAN'
445 'TADYIKISTAN'
446 'TURKMENISTAN'
447 'UZBEKISTAN'
448 'ISLAS MARIANAS DEL NORTE'
449 'PALESTINA'
450 'HONG KONG'
453 'BHUTÁN'
454 'GUAM'
455 'MACAO'
499 'OTROS PAISES O TERRITORIOS DE ASIA'
501 'AUSTRALIA'
502 'FIJI'
504 'NUEVA ZELANDA'
505 'PAPUA NUEVA GUINEA'
506 'ISLAS SALOMON'
507 'SAMOA'
508 'TONGA'
509 'VANUATU'
511 'MICRONESIA'
512 'TUVALU'
513 'ISLAS COOK'
515 'NAURU'
516 'PALAOS'
517 'TIMOR ORIENTAL'
520 'POLINESIA FRANCESA'
521 'ISLA NORFOLK'
522 'KIRIBATI'
523 'NIUE'
524 'ISLAS PITCAIRN'
525 'TOKELAU'
526 'NUEVA CALEDONIA'
527 'WALLIS Y FORTUNA'
528 'SAMOA AMERICANA'
555 'Apátridas'
599 'OTROS PAISES O TERRITORIOS DE OCEANIA'
999 'No consta'
/ECIV
1 'Soltero'
2 'Casado'
3 'Viudo'
4 'Separado/divorciado'
/LUGRES
1 'España'
2 'Extranjero'
/CODPROF
00 'Personas que no pueden ser clasificadas o no consta'
01 'Fuerzas armadas'
02 'Dirección de las empresas y de las administraciones públicas'
03 'Técnicos y profesionales científicos e intelectuales'
04 'Técnicos y profesionales de apoyo'
05 'Empleados de tipo administrativo'
06 'Trabajadores de los servicios de restauración'
07 'Trabajadores cualificados en la agricultura y la pesca'
08 'Artesanos y trabajadores cualificados de las industrias manufactureras,...'
09 'Operadores de instalaciones y maquinaria y montadores'
10 'Trabajadores no cualificados'
11 'Estudiantes'
12 'Personas que realizan o comparten las tareas del hogar'
13 'Pensionistas/rentistas'
14 'Parados'
/TAMAMUNI, TAMAMUNINAC, TAMAMUNIRES
1 'MUNICIPIO =< 10.000 HABITANTES'
2 'MUNICIPIO DE 10.001 A  20.000 HABITANTES'
3 'MUNICIPIO DE 20.001 A  50.000 HABITANTES'           
4 'MUNICIPIO DE 50.001 A 100.000 HABITANTES'         
5 'MUNICIPIO  MAYOR  DE  100.000 HABITANTES'
6 'Capital de provincia'                                        
/TAMAPAISNACIMI, TAMAPAISRESIDE, TAMAPAISNACIONA
1 'Desagregado'
2 'Resto de países'
3 'No consta' 
/CAUSAR
1 ' Enfermedades infecciosas intestinales'
2 ' Tuberculosis y sus efectos tardíos'
3 ' Enfermedad meningocócica'
4 ' Septicemia'
5 ' Hepatitis vírica'
6 ' SIDA'
7 ' VIH+ (portador, evidencias de laboratorio del VIH, ...)'
8 ' Resto de enfermedades infecciosas y parasitarias y sus efectos tardíos'
9 ' Tumor maligno del labio, de la cavidad bucal y de la faringe'
10 ' Tumor maligno del esófago'
11 ' Tumor maligno del estómago'
12 ' Tumor maligno del colon'
13 ' Tumor maligno del recto, de la porción rectosigmoide y del ano'
14 ' Tumor maligno del hígado y vías biliares intrahepáticas'
15 ' Tumor maligno del páncreas'
16 ' Otros tumores malignos digestivos'
17 ' Tumor maligno de la laringe'
18 ' Tumor maligno de la tráquea, de los bronquios y del pulmón'
19 ' Otros tumores malignos respiratorios e intratorácicos'
20 ' Tumores malignos del hueso y de los cartílagos articulares'
21 ' Melanoma maligno de la piel'
22 ' Otros tumores malignos de la piel y de los tejidos blandos'
23 ' Tumor maligno de la mama'
24 ' Tumor maligno del cuello del útero'
25 ' Tumor maligno de otras partes del útero'
26 ' Tumor maligno del ovario'
27 ' Tumores malignos de otros órganos genitales femeninos'
28 ' Tumor maligno de la próstata'
29 ' Tumores malignos de otros órganos genitales masculinos'
30 ' Tumor maligno del riñón, excepto pelvis renal'
31 ' Tumor maligno de la vejiga'
32 ' Otros tumores malignos de las vías urinarias'
33 ' Tumor maligno del encéfalo'
34 ' Otros tumores malignos neurológicos y endocrinos'
35 ' Tumor maligno de sitios mal definidos, secundarios y de sitios no especificados'
36 ' Tumores malignos del tejido linfático, de los órganos hematopoyéticos y de tejidos afines, excepto leucemia'
37 ' Leucemia'
38 ' Tumores in situ'
39 ' Tumores benignos'
40 ' Síndrome mielodisplásico'
41 ' Otros tumores de comportamiento incierto o desconocido'
42 ' Enfermedades de la sangre y de los órganos hematopoyéticos'
43 'Ciertos trastornos que afectan al mecanismo de la inmunidad'
44 ' Diabetes mellitus'
45 ' Otras enfermedades endocrinas, nutricionales y metabólicas'
46 ' Trastornos mentales orgánicos, senil y presenil'
47 ' Trastornos mentales debidos al uso de alcohol'
48 ' Trastornos mentales debidos al uso de drogas (drogodependencia, toxicomanía)'
49 ' Otros trastornos mentales y del comportamiento'
50 ' Meningitis (otras en 003)'
51 ' Enfermedad de Alzheimer'
52 ' Otras enfermedades del sistema nervioso y de los órganos de los sentidos'
53 ' Enfermedades cardíacas reumáticas crónicas'
54 ' Enfermedades hipertensivas'
55 ' Infarto agudo de miocardio'
56 ' Otras enfermedades isquémicas del corazón'
57 ' Insuficiencia cardíaca'
58 ' Otras enfermedades del corazón'
59 ' Enfermedades cerebrovasculares'
60 ' Aterosclerosis'
61 ' Otras enfermedades de los vasos sanguíneos'
62 ' Influenza (gripe) (incluye gripe aviar y gripe A)'
63 ' Neumonía'
64 ' Enfermedades crónicas de las vías respiratorias inferiores (excepto asma)'
65 ' Asma'
66 ' Insuficiencia respiratoria'
67 ' Otras enfermedades del sistema respiratorio'
68 ' Úlcera de estómago, duodeno y yeyuno'
69 ' Enteritis y colitis no infecciosas'
70 ' Enfermedad vascular intestinal'
71 ' Cirrosis y otras enfermedades crónicas del hígado'
72 ' Otras enfermedades del sistema digestivo'
73 ' XII.Enfermedades de la piel y del tejido subcutáneo'
74 ' Artritis reumatoide y osteoartrosis'
75 ' Osteoporosis y fractura patológica'
76 ' Otras enfermedades del sistema osteomuscular y del tejido conjuntivo'
77 ' Enfermedades del riñón y del uréter'
78 ' Enfermedades de los órganos genitales masculinos'
79 ' Enfermedades de los órganos genitales femeninos y trastornos de la mama'
80 ' Otras enfermedades del sistema genitourinario'
81 ' XV.Embarazo, parto y puerperio'
82 ' XVI.Afecciones originadas en el periodo perinatal'
83 ' Malformaciones congénitas del sistema nervioso'
84 ' Malformaciones congénitas del sistema circulatorio'
85 ' Otras malformaciones congénitas, deformidades y anomalías cromosómicas'
86 ' Paro cardíaco, muerte sin asistencia y otra causa desconocida de mortalidad'
87 ' Senilidad'
88 ' Muerte súbita infantil'
89 ' Resto de síntomas, signos y hallazgos anormales clínicos y de laboratorio, no clasificados en otra parte'
90 ' Accidentes de tráfico'
91 ' Otros accidentes de transporte'
92 ' Caídas accidentales'
93 ' Ahogamiento, sumersión y sofocación accidentales'
94 ' Accidentes por fuego, humo y sustancias calientes'
95 ' Envenenamiento accidental por psicofármacos y drogas de abuso'
96 ' Otros envenenamientos accidentales'
97 ' Otros accidentes'
98 ' Suicidio y lesiones autoinfligidas'
99 'Agresiones (homicidio)'
100 ' Eventos de intención no determinada'
101 ' Complicaciones de la atención médica y quirúrgica'
102 ' Otras causas externas y sus efectos tardíos'
/CAUSAP
1 'Feto y recien nacido afectados por condiciones de la madre no necesariamente relacionadas con el embarazo presente'
2 'Feto y recien nacido afectados por incompetencia del cuello uterino'
3 'Feto y recien nacido afectados por ruptura prematura de las membranas'
4 'Feto y recien nacido afectados por embarazo multiple'
5 'Feto y recien nacido afectados por otras complicaciones maternas del embarazo y las no especificadas'
6 'Feto y recien nacido afectados por placenta previa'
7 'Feto y recien nacido afectados por otras formas de desprendimiento y de hemorragia placentarios'
8 'Feto y recien nacido afectados por sindromes de transfusion placentaria y otras anomalias morfologicas y funcionales'
9 'Feto y recien nacido afectados por prolapso, compresión y otras complicaciones del cordon umbilical y las no especi'
10 'Feto y recien nacido afectados por complicaciones del corion, del amnios y las no especificadas de las membranas'
11 'Feto y recien nacido afectados por presentacion anomala, posicion anomala y desproporcion durante el trabajo de parto y'
12 'Feto y recien nacido afectados por otras complicaciones y las no especificadas del trabajo de parto y del parto'
13 'Feto y recien nacido afectados por influencias nocivas transmitidas a traves de la placenta o de la leche materna'
14 'Retardo del crecimiento fetal y desnutricion fetal'
15 'Inmaturidad extrema y peso extremadamente bajo al nacer'
16 'Otros recien nacidos pretermino y peso bajo al nacer'
17 'Trastornos relacionados con el embarazo prolongado y con sobrepeso al nacer'
18 'Hemorragia y laceracion intracraneal debidas a traumatismo del nacimiento'
19 'Otros traumatismos del nacimiento en otras partes y en las no especificadas'
20 'Hipoxia intrauterina'
21 'Asfixia del nacimiento'
22 'Dificultad respiratoria del recien nacido'
23 'Neumonia congenita'
24 'Sindromes de aspiracion neonatal'
25 'Enfisema intersticial y afecciones relacionadas, originadas en el periodo perinatal'
26 'Hemorragia pulmonar originada en el periodo perinatal'
27 'Otros problemas respiratorios del recien nacido originados en el periodo perinatal'
28 'Trastornos cardiovasculares originados en el periodo perinatal'
29 'Enfermedades virales congenitas'
30 'Sepsis bacteriana del recien nacido'
31 'Onfalitis del recien nacido'
32 'Otras enfermedades infecciosas y parasitarias específicas del periodo perinatal'
33 'Hemorragia intracraneal no traumatica del feto y del recien nacido'
34 'Otras hemorragias neonatales y las no especificadas'
35 'Enfermedad hemolitica del feto y del recien nacido'
36 'Ictericia neonatal debida a otras hemolisis y por otras causas y las no especificadas'
37 'Coagulacion intravascular diseminada en el feto y en el recien nacido'
38 'Otros trastornos hematologicos perinatales'
39 'Sindrome del recien nacido de madre con diabetica'
40 'Diabetes mellitus neonatal'
41 'Hipertiroidismo neonatal transitorio'
42 'Otras alteraciones metabolicas y electrolíticas neonatales transitorias y las no específicas'
43 'Otras obtrucciones intestinales del recién nacido'
44 'Enterocolitis necrotizante del feto y del recien nacido'
45 'Otros trastorno perinatal del sistema digestivo'
46 'Alteraciones de la regulacion de la temperatura del recien nacido'
47 'Hidropesia fetal no debida a enfermedad hemolitica'
48 'Otras afeccion de la piel no especificada del feto y del recien nacido'
49 'Otras trastornos originados en el periodo perinatal'
50 'Anencefalia y malformaciones congenitas similares'
51 'Encefalocele'
52 'Microcefalia'
53 'Hidrocefalo congenito'
54 'Otras malformaciones congenitas del encefalo'
55 'Espina bifida'
56 'Otras malformaciones congenitas de la medula espinal'
57 'Malformacion congenita del sistema nervioso'
58 'Malformaciones congénitas del ojo, del oído, de la cara y del cuello'
59 'Malformaciones congenitas de las camaras y de los tabiques cardiacos y sus conexiones'
60 'Malformaciones congenitas de las valvulas cardíacas'
61 'Otras malformaciones congenitas del corazon'
62 'Malformaciones congenitas de las grandes arterias y venas y del sistema vascular periférico'
63 'Otras malformaciones congenitas del sistema circulatorio'
64 'Malformaciones congenitas de la nariz, laringe, tráquea y brónquios'
65 'Malformaciones congenitas del pulmon'
66 'Otras malformacion congenita del sistema respiratorio'
67 'Fisura del paladar y labio leporino'
68 'Malformaciones congénitas de la lengua, boca, faringe, esófago y estómago'
69 'Malformaciones congénitas del intestino'
70 'Otras malformaciones cogénitas del sistema digestivo'
71 'Malformaciones congenitas de los órganos genitales'
72 'Agenesia renal y otras malformaciones hipoplasicas del rinon'
73 'Enfermedad quistica del rinon'
74 'Defectos obstructivos congenitos de la pelvis renal y malformaciones congenitas del ureter'
75 'Malformacion congenita del riñon'
76 'Otras malformaciones congenitas del sistema urinario'
77 'Malformaciones y deformidades congénitas del sistema osteomuscular'
78 'Otras malformaciones congénitas no clasificadas en otra parte'
79 'Sindrome de down'
80 'Síndrome de edwards'
81 'Síndrome de patau'
82 'Otras anomalias cromosomicas'
83 'Tétanos neonatal y otras enfermedades infecciosas y parasitarias'
84 'Tumores'
85 'Enfermedades de la sangre y de los órganos hematopoyéticos y ciertos trastornos que afectan al mecanismo de la inmunidad'
86 'Enfermedades endocrinas, nutricionales y metabólicas'
87 'Ileo meconial'
88 'muerte súbita infantil'
89 'Otras afecciones, síntomas, signos y hallazgos anormales clínicos y de laboratorio, no clasificados en otra partes'
90 'Accidentes de transporte'
91 'Accidentes que obstruyen la respiración'
92 'Agresiones (homicidio)'
93 'Otras causas externas'
/CAUSAINF
1 'Enfermedades infecciosas intestinales'
2 'Enfermedad meningocócica'
3 'SIDA'
4 'VIH+ (portador, evidencias de laboratorio del VIH,...)'
5 'Resto de enfermedades infecciosas y parasitarias'
6 'II.Tumores'
7 'Enfermedades de la sangre y de los órganos hematopoyéticos'
8 'Ciertos trastornos que afectan el mecanismo de la inmunidad'
9 'Trastornos de las glándulas suprarrenales'
10 'Trastornos del transporte y del metabolismo de los aminoácidos'
11 'Fibrosis quística'
12 'Otras enfermedades endocrinas, nutricionales y metabólicas'
13 'Meningitis (otras en 02)'
14 'Atrofia muscular espinal infantil, tipo I (Werdnig-Hoffman)'
15 'Otras enfermedades del sistema nervioso y de los órganos de los sentidos'
16 'IX.Enfermedades del sistema circulatorio'
17 'Infecciones agudas de las vías respiratorias'
18 'Influenza (gripe) (incluye gripe aviar y gripe A)'
19 'Neumonía'
20 'Asma'
21 'Otras enfermedades del sistema respiratorio'
22 'Obstrucción intestinal sin mención de hernia'
23 'Otras enfermedades del sistema digestivo'
24 'XII.Enfermedades de la piel y del tejido subcutáneo'
25 'XIII.Enfermedades del sistema osteomuscular y del tejido conjuntivo'
26 'XIV.Enfermedades del sistema genitourinario'
27 'Recién nacido afectado por condiciones de la madre no necesariamente relacionadas con el embarazo presente'
28 'Recién nacido afectado por complicaciones maternas del embarazo'
29 'Recién nacido afectado por complicaciones de la placenta, del cordón umbilical y de las membranas'
30 'Recién nacido afectado por otras complicaciones del trabajo de parto y del parto'
31 'Recién nacido afectado por influencias nocivas transmitidas a través de la placenta o de la leche materna'
32 'Trastornos relacionados con la duración de la gestación y el crecimiento fetal'
33 'Traumatismo del nacimiento'
34 'Trastornos respiratorios y cardiovasculares específicos del periodo perinatal'
35 'Infecciones específicas del periodo perinatal'
36 'Trastornos hemorrágicos y hematológicos del recién nacido'
37 'Trastornos endocrinos y metabólicos transitorios específicos del recién nacido'
38 'Trastornos del sistema digestivo del recién nacido'
39 'Otros trastornos originados en el periodo perinatal'
40 'Malformaciones congénitas del sistema nervioso'
41 'Malformaciones congénitas del sistema circulatorio'
42 'Malformaciones congénitas del sistema respiratorio'
43 'Malformaciones congénitas del sistema digestivo'
44 'Malformaciones congénitas del sistema urinario'
45 'Malformaciones y deformidades congénitas del sistema osteomuscular'
46 'Anomalías congénitas múltiples'
47 'Anomalías cromosómicas'
48 'Otras malformaciones congénitas'
49 'Muerte súbita infantil'
50 'Otras afecciones, síntomas, signos y hallazgos anormales clínicos y de laboratorio, no clasificados en otra parte'
51 'Accidentes de transporte'
52 'Broncoaspiración por alimentos y vómitos'
53 'Agresiones (Homicidio)'
54 'Otras causas externas'
/NESTUDIOS
01 'Analfabetos'
02 'Estudios primarios incompletos'
03 'Educación primaria'
04 'Primera etapa de educación secundaria y similar'
05 'Segunda etapa de educación secundaria con orientación general'
06 'Segunda etapa de educación secundaria con orientación profesional'
08 'Enseñanzas de formación profesional, artes plásticas y diseño y deportivas de grado superior y equivalentes'
09 'Grados universitarios de 240 créditos ECTS, diplomados universitarios, títulos propios universitarios de expert'
10 'Grados universitarios de más de 240 créditos ECTS, licenciados, másteres y especialidades en Ciencias de'
11 'Másteres, especialidades en Ciencias de la Salud por el sistema de residencia y similares'
12 'Doctorado universitario'
99 'no consta'
/LUGARDEF
0 'No consta'
1 'Domicilio'
2 'Hospital'
3 'Residencia Socio-Sanitaria'
4 'Lugar de trabajo u Otro lugar'.
EXECUTE.

STRING  CIE10 (A4). 
COMPUTE CIE10=CONCAT(CBAS1,CBAS23,CBAS4). 
VARIABLE LABELS  CIE10 'Código CIE10 causa defunción'. 
EXECUTE.

STRING CIE10_1 (A2).
*Modificaciones para poder indicar a qué capítulo CIE pertenece cada código CIE: la letra se convertirá en el entero de un número con decimales.
* Recodificamos las letras de los códigos CIE.
RECODE CBAS1 ('A'='01') ('B'='02') ('C'='03') ('D'='04')('E'='05')('F'='06')('G'='07')('H'='08')('I'='09')('J'='10')('K'='11')('L'='12')('M'='13')('N'='14')('O'='15')('P'='16')('Q'='17')('R'='18')('S'='19')
('T'='20')('V'='21')('W'='22')('X'='23')('Y'='24')('Z'='25') ('U'='26') INTO CIE10_1. 
EXECUTE.

* Unimos los numéricos de los CIE10.
STRING  CIE10_2 (A3). 
COMPUTE CIE10_2=CONCAT(CBAS23,CBAS4). 
EXECUTE.

*los códigos numéricos los convertimos a parte decimal.
STRING  CIE10_3s (A6). 
COMPUTE CIE10_3s=CONCAT(CIE10_1,',',CIE10_2). 
EXECUTE.

*convertimos CIE10_3s a numérico
NUMERIC CIE10_3 (F6.3).
compute CIE10_3 = number(CIE10_3s, F6.3).
EXECUTE.

numeric CIE10_Cap (F2.0). 
VARIABLE LABELS 
CIE10_Cap 'Capítulo CIE10 causa defunción'.
RECODE CIE10_3 (0.000 thru 2.990=1) (3.000 thru 4.489=2) (4.500 thru 4.899=3) (5.000 thru 5.900=4) (6.000 thru 6.990=5) (7.000 thru 7.998=6) (8.000 thru 8.599=7)
(8.600 thru 8.959=8) (9.000 thru 9.990=9) (10.000 thru 10.998=10) (11.000 thru 11.938=11) (12.000 thru 12.998=12) (13.000 thru 13.999=13) (14.000 thru 14.999=14)
(15.000 thru 15.998=15) (16.000 thru 16.969=16) (17.000 thru 17.999=17) (18.000 thru 18.990=18) (19.000 thru 20.983=19) (21.010 thru 24.980=20) (25.000 thru 25.999=21)
(26.000 thru 26.899=22) INTO CIE10_Cap. 
EXECUTE.

VALUE LABELS 
/CIE10_Cap
1 '1 I Ciertas enfermedades infecciosas y parasitarias'
2 '2 II Neoplasias'
3 '3 III Enfermedades de la sangre y de los organos hematopoyeticos y'
4  '4 IV Enfermedades endocrinas, nutricionales y metabolicas'
5  '5 V Trastornos mentales y del comportamiento'
6  '6 VI Enfermedades del sistema nervioso'
7  '7 VII Enfermedades del ojo y sus anexos'
8  '8 VIII Enfermedades del oido y de la apofisis mastoides'
9  '9 IX Enfermedades del sistema circulatorio'
10  '10 X Enfermedades del sistema respiratorio'
11  '11 XI Enfermedades del aparato digestivo'
12  '12 XII Enfermedades de la piel y el tejido subcutaneo'
13  '13 XIII Enfermedades del sistema osteomuscular y del tejido conectivo'
14  '14 XIV Enfermedades del aparato genitourinario'
15  '15 XV Embarazo, parto y puerperio'
16  '16 XVI Ciertas afecciones originadas en el periodo perinatal'
17  '17 XVII Malformaciones congenitas, deformidades y anomalias cromosomicas'
18  '18 XVIII Sintomas, signos y hallazgos anormales clinicos y de laboratorio, no clasificados en otra par'
19  '19 XIX Traumatismos, envenenamientos y algunas otras consecuencias de causa externa'
20  '20 XX Causas extremas de morbilidad y de mortalidad'
21  '21 XXI Factores que influyen en el estado de salud y contacto con los servicios de salud'
22  '22 XXII Codigos para situaciones especiales'.
EXECUTE.

NUMERIC CIE10_CapXVII (F5.0). 
VARIABLE LABELS 
CIE10_CapXVII 'XVII Malformaciones congenitas, deformidades y anomalias cromosomicas causa defunción'.
RECODE CIE10_3 (17.000 thru 17.079=1) (17.100 thru 17.189=2) (17.200 thru 17.289=3) (17.300 thru 17.349=4) (17.350 thru 17.379=5) (17.380 thru 17.459=6) (17.500 thru 17.564=7)
(17.600 thru 17.649=8) (17.650 thru 17.799=9) (17.800 thru 17.899=10) (17.900 thru 17.999=11) INTO CIE10_CapXVII. 
EXECUTE.

VALUE LABELS 
/CIE10_CapXVII
1 'Malfomaciones congénitas del sistema nervioso'
2 'Malformaciones congénitas del ojo, del oído de la cara y del cuello'
3 'Malformaciones congénitas del sistema circulatorio'
4 'Malformaciones congénitas del sistema respiratorio'
5 'Fisura del paladar y labio leporino'
6 'Otras malformaciones congénitas del sistema digestivo'
7 'Malformaciones congénitas de los órganos genitales'
8 'Malformaciones congénitas del sistema urinario'
9 'Malformaciones y deformidades congénitas del sistema osteomuscular'
10 'Otras malformaciones congénitas'
11 'Anomalías cromosómicas no clasificadas en otra parte'.
EXECUTE.

NUMERIC CIE10_CatV7 (F2.0). 
VARIABLE LABELS 
CIE10_CatV7 'V7 Retraso mental'.
RECODE CIE10_3 (6.70=1) (6.700=2) (6.701=3) (6.708=4) (6.709=5) (6.71=6) (6.710=7) (6.711=8) (6.718=9) (6.719=10) (6.72=11) (6.720=12) (6.721=13)(6.728=14)
(6.729=15)(6.73=16) (6.730=17) (6.731=18)(6.738=19)(6.739=20) (6.78=21) (6.780=22) (6.781=23)(6.788=24)(6.789=25) (6.79=26) (6.790=27) (6.791=28)(6.798=29)
(6.799=30) INTO CIE10_CatV7.
EXECUTE.

VALUE LABELS 
/CIE10_CatV7
 1 'F70 Retraso mental leve'
2 ' F700 Retraso mental leve: deterioro del comportamiento nulo o minimo'
3 ' F701 Retraso mental leve: deterioro del comportamiento significativo, que requiere atencion o tratamiento'
4 ' F708 Retraso mental leve: otros deterioros del comportamiento'
5 ' F709 Retraso mental leve: deterioro del comportamiento de grado no especificado'
6 ' F71 Retraso mental moderado'
7 ' F710 Retraso mental moderado: deterioro del comportamiento nulo o minimo'
8 ' F711 Retraso mental moderado: deterioro del comportamiento significativo, que requiere atencion o tratamiento'
9 ' F718 Retraso mental moderado: otros deterioros del comportamiento'
10 ' F719 Retraso mental moderado: deterioro del comportamiento de grado no especificado'
11 ' F72 Retraso mental grave'
12 ' F720 Retraso mental grave: deterioro del comportamiento nulo o minimo'
13 ' F721 Retraso mental grave: deterioro del comportamiento significativo, que requiere atencion o tratamiento'
14 ' F728 Retraso mental grave: otros deterioros del comportamiento'
15 ' F729 Retraso mental grave: deterioro del comportamiento de grado no especificado'
16 ' F73 Retraso mental profundo'
17 ' F730 Retraso mental profundo: deterioro del comportamiento nulo o minimo'
18 ' F731 Retraso mental profundo: deterioro del comportamiento significativo, que requiere atencion o tratamiento'
19 ' F738 Retraso mental profundo: otros deterioros del comportamiento'
20 ' F739 Retraso mental profundo: deterioro del comportamiento de grado no especificado'
21 ' F78 Otros tipos de retraso mental'
22 ' F780 Otros tipos de retraso mental profundo: deterioro del comportamiento nulo o minimo'
23 ' F781 Otros tipos de retraso mental profundo: deterioro del comportamiento significativo, que requiere atencion o trata'
24 ' F788 Otros tipos de retraso mental profundo: otros deterioros del comportamiento'
25 ' F789 Otros tipos de retraso mental profundo: deterioro del comportamiento de grado no especificado'
26 ' F79 Retraso mental no especificado'
27 ' F790 Retraso mental, no especificado: deterioro del comportamiento nulo o minimo'
28 ' F791 Retraso mental, no especificado: deterioro del comportamiento significativo, que requiere atencion o tratamiento'
29 ' F798 Retraso mental, no especificado: otros deterioros del comportamiento'
30 ' F799 Retraso mental, no especificado: deterioro del comportamiento de grado no especificado.'.
EXECUTE .

NUMERIC CIE10_CatV7_SN (F1.0).
VARIABLE LABELS 
CIE10_CatV7_SN 'Retraso Mental Si/No'.
VALUE LABELS 
CIE10_CatV7_SN
1 'Sí'
0 'No'.
RECODE CIE10_CatV7 (sysmis=0)(0=0) (ELSE=1) INTO CIE10_CatV7_SN. 
EXECUTE.

NUMERIC CIE10_CapXVII_T21_FX (F1.0). 
VARIABLE LABELS 
CIE10_CapXVII_T21_FX 'S. Down y Frágil X causa defunción'.
RECODE CIE10_3 (17.900 thru 17.909=1) (17.992=2) (ELSE=0) INTO CIE10_CapXVII_T21_FX. 
EXECUTE.
VALUE LABELS 
/CIE10_CapXVII_T21_FX
1 'S Down'
2 'Frágil X'
0 'Resto'.
EXECUTE.

*Creamos valores para los grupos de causas reducidas de defunción.
NUMERIC CAUSAR_Cap (F3.0).
VARIABLE LABELS
CAUSAR_Cap 'Causas reducidas (grupos)'.
RECODE CAUSAR (1 thru 8=1) (9 thru 41=2)(42 thru 43=3)(44 thru 45=4)(46 thru 49=5)(50 thru 52=6)(53 thru 61=7)(62 thru 67=8)(68 thru 72=9)(73=10)(74 thru 76=11)(77 thru 80=12)
(81=13) (82=14)(83 thru 85=15)(86 thru 89=16)(90 thru 102=17) INTO CAUSAR_Cap.
EXECUTE .
VALUE LABELS 
/CAUSAR_Cap
1 'I.Enfermedades infecciosas y parasitarias'
2 'II.Tumores'
3 'III.Enfermedades de la sangre y de los órganos hematopoyéticos, y'
4 'IV.Enfermedades endocrinas, nutricionales y metabólicas'
5 'V.Trastornos mentales y del comportamiento'
6 'VI-VIII.Enfermedades del sistema nervioso y de los órganos de los sentidos'
7 'IX.Enfermedades del sistema circulatorio'
8 'X.Enfermedades del sistema respiratorio'
9 'XI.Enfermedades del sistema digestivo'
10 'XII.Enfermedades de la piel y del tejido subcutáneo'
11 'XIII.Enfermedades del sistema osteomuscular y del tejido conjuntivo'
12 'XIV.Enfermedades del sistema genitourinario'
13 'XV.Embarazo, parto y puerperio'
14 'XVI.Afecciones originadas en el periodo perinatal'
15 'XVII.Malformaciones congénitas, deformidades y anomalías cromosómicas'
16 'XVIII.Síntomas, signos y hallazgos anormales clínicos y de laboratorio, no clasificados en otra parte'
17 'XX.Causas externas de mortalidad'.
EXECUTE.

*Creamos valores para los grupos de causas reducidas de muerte perinatal.
NUMERIC CAUSAP_Cap (F3.0).
VARIABLE LABELS
CAUSAP_Cap 'Causas reducidas perinatales'.
RECODE CAUSAP (1=1) (2 thru 5=2)(6 thru 10=3)(11 thru 12=4)(13=5)(14 thru 17=6)(18 thru 19=7)(20 thru 28=8)(29 thru 32=9)(33 thru 38=10)(39 thru 42=11)(43 thru 45=12)
(46 thru 48=13) (49=14)(50 thru 57=15) (58=16)(59 thru 63=17)(64 thru 66=18)(67=19)(68 thru 70=20)(71=21)(72 thru 76=22)(77=23)(78=24) (79 thru 82=25)(83 thru 89=26)
(90 thru 93=27) INTO CAUSAP_Cap.
EXECUTE .
VALUE LABELS 
/CAUSAP_Cap
1 'Feto y recien nacido afectados por condiciones de la madre no necesariamente relacionadas con el embarazo presente'
2 'Feto y recien nacido afectados por complicaciones maternas del embarazo'
3 'Feto y recien nacido afectados por complicaciones de la placenta, del cordon umbilical y de las membranas'
4 'Feto y recien nacido afectados por otras complicaciones del trabajo de parto y del parto'
5 'Feto y recien nacido afectados por influencias nocivas transmitidas a traves de la placenta o de la leche materna'
6 'Trastornos relacionados con la duración de la gestación y el crecimiento fetal'
7 'Traumatismos del nacimiento'
8 'Trastornos respiratorios y cardiovasculares específicos del periodo perinatal'
9 'Infecciones específicas del periodo perinatal'
10 'Trastornos hemorrágicos y hematológicos del feto y del recien nacido'
11 'Trastornos endocrinos y metabólicos transitorios específicos del feto y del recién nacido'
12 'Trastornos del sistema digestivo del feto y del recién nacido'
13 'Alteraciones asociadas con la regulación tegumentaria y la temperatura del feto y del recién nacido'
14 'Otros trastornos originados en el periodo perinatal'
15 'Malformaciones congénitas del sistema nervioso'
16 'Malformaciones congénitas del ojo, del oído, de la cara y del cuello'
17 'Malformaciones congénitas del sistema circulatorio'
18 'Malformaciones congénitas del sistema respiratorio'
19 'Fisura del paladar y labio leporino'
20 'Otras malformaciones congenitas del sistema digestivo'
21 'Malformaciones congenitas de los órganos genitales'
22 'Malformaciones congenitas del sistema urinario'
23 'Malformaciones y deformidades congénitas del sistema osteomuscular'
24 'Otras malformaciones congénitas no clasificadas en otra parte'
25 'Anomalías cromosómicas'
26 'Otras enfermedades del feto y del recién nacido'
27 'Causas externas de lesiones ocurridas al recién nacido'.
EXECUTE .

*Creamos valores para los grupos de causas reducidas de muerte infantil.
NUMERIC CAUSAINF_Cap (F3.0).
VARIABLE LABELS
CAUSAINF_Cap 'Causas reducidas menores 1 año (grupos)'.
RECODE CAUSAINF (1 thru 5=1) (6=2)(7 thru 8=3)(9 thru 12=4)(13 thru 15=5)(16=6)(17 thru 21=7)(22 thru 23=8)(24=9)(25=10)(26=11)(27 thru 39=12)
(40 thru 48=13) (49 thru 50=14)(51 thru 54=15) INTO CAUSAINF_Cap.
EXECUTE .
VALUE LABELS 
/CAUSAINF_Cap
1 'I.Enfermedades infecciosas y parasitarias'
2 'II.Tumores'
3 'III.Enfermedades de la sangre y de los órganos hematopoyéticos, y '
4 'IV.Enfermedades endocrinas, nutricionales y metabólicas'
5 'VI-VIII.Enfermedades del sistema nervioso y de los órganos de los sentidos'
6 'IX.Enfermedades del sistema circulatorio'
7 'X.Enfermedades del sistema respiratorio'
8 'XI.Enfermedades del sistema digestivo'
9 'XII.Enfermedades de la piel y del tejido subcutáneo'
10 'XIII.Enfermedades del sistema osteomuscular y del tejido conjuntivo'
11 'XIV.Enfermedades del sistema genitourinario'
12 'XVI.Afecciones originadas en el periodo perinatal'
13 'XVII.Malformaciones congénitas, deformidades y anomalías cromosómicas'
14 'V, XVIII Trastornos mentales.Síntomas, signos y hallazgos anormales clínicos y de laboratorio, no'
15 'XX.Causas externas de mortalidad'.
EXECUTE.

*Elimino variables de transición.
DELETE VARIABLES CIE10_1, CIE10_2, CIE10_3s, CIE10_3.
EXECUTE.

STRING Edad_Gr5 (A5). 
VARIABLE LABELS 
Edad_Gr5 'Grupos quinquenales de edad cumplida a defunción'.
RECODE ANOSC (0 thru 4='00-04') (5 thru 9='05-09') (10 thru 14='10-14') (15 thru 19='15-19') (20 thru 24='20-24') (25 thru 29='25-29') (30 thru 34='30-34') (35 thru 39='35-39')
(40 thru 44='40-44') (45 thru 49='45-49') (50 thru 54='50-54') (55 thru 59='55-59') (60 thru 64='60-64') (65 thru 69='65-69') (70 thru 74='70-74') (75 thru 79='75-79') 
(80 thru 84='80-84') (85 thru 89='85-89') (90 thru 200='90+') (100 thru 200='M100') INTO Edad_Gr5. 
EXECUTE. 

*Guardamos el archico como 2012PSPP.sav.
    SAVE OUTFILE='/home/lluc1/Documents/Estudis/Epidemiologia/Esperanza/2012-2013/2012PSPP.sav'.
DATASET NAME DataSet1.
